<?php
/* --------------------------------------------------------------
   AutoUpdaterFtpAdapter.inc.php 2018-09-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use League\Flysystem\Adapter\Ftp;

/**
 * Class AutoUpdaterFtpAdapter
 */
class AutoUpdaterFtpAdapter extends Ftp
{
	/**
	 * Change file permissions via ftp.
	 *
	 * @param string $path
	 * @param int $mode
	 *
	 * @return bool
	 */
	public function chmod($path, $mode)
	{
		$ftpPath = $this->getRoot() . ltrim($path, '/');
		if(false === @$this->has($ftpPath))
		{
			return false;
		}
		
		return @ftp_chmod($this->getConnection(), $mode, $path) !== false;
	}
}
